	% Ex 5.10
	%           Bandpass filter design using EQR algorithm
	
	% 	Author: 		Lars Wanhammar 2007-09-13
	
	clear all
	close all
	clc
	ws1T = 0.24*pi; wc1T = 0.35*pi; wc2T = 0.65*pi; ws2T = 0.75*pi;
	Amax = 1.0; Amin1 = 60; Amin2 = 50;
	deltac1 = (10^(Amax/20)-1)/(10^(Amax/20)+1);% Maximum allowable two 
	deltas1 = (1+deltac1)*(10^(-Amin1/20));     % stopband deviations and one
	deltas2 = (1+deltac1)*(10^(-Amin2/20));     % passband deviation
	d = [deltas1 deltac1 deltas2];
	wTedges = [ws1T wc1T wc2T ws2T];
	[N, Be, D, W] = L_PHASE_BP_FIR_ORDER(wTedges,d); 
	Norder = N-7; 								% Minimum order
	fprintf('Minimum order to meet the criteria is %4.0f\n', Norder)
	
	[h, Err] = REMEZ_FIR(Norder, Be, D, W, 'm'); 
	Deltas1 = Err/W(1);		 % Resulting two stopband
	Deltac1 = Err/W(2); 			% stopband ripples and one
	Deltas2 = Err/W(3); 			% one passband
	wT = linspace(0, pi, 2000);
	hn = h/(1+Deltac1); 			% Normalize the gain
	Att = H_2_ATT(freqz(hn, 1, wT)); 
	subplot('position', [0.1 0.4 0.88 0.5]); PLOT_ATT_Z(wT, Att, pi, 80)
	axis([0 pi 0 80]), grid on, zoom on  
	fprintf('Err= %2.8f \n', Err);
	Amax = 20*log10((1+Deltac1)/(1-Deltac1));
	fprintf('Passband: Amax = %2.6f dB \n', Amax)
	Amin1 = H_2_MAG((1+Deltac1)/Deltas1);
	fprintf('First Stopband: Amin1= %2.4f dB \n', Amin1)
	Amin2 = H_2_MAG((1+Deltac1)/Deltas2);
	fprintf('Second Stopband: Amin2= %2.4f dB \n', Amin2)
	
	
	
